///////////////////////////////////////////////////////////////////////  
//  SpeedTree.fx
//
//  SpeedTree.fx is the file passed to the shader compiler.  It includes the other 
//  SpeedTree FX/Cg files.  These shaders will compile with HLSL and Cg compilers.
//
//
//  *** INTERACTIVE DATA VISUALIZATION (IDV) CONFIDENTIAL AND PROPRIETARY INFORMATION ***
//
//  This software is supplied under the terms of a license agreement or
//  nondisclosure agreement with Interactive Data Visualization, Inc. and
//  may not be copied, disclosed, or exploited except in accordance with 
//  the terms of that agreement.
//
//      Copyright (c) 2003-2009 IDV, Inc.
//      All rights reserved in all media.
//
//      IDV, Inc.
//      http://www.idvinc.com

#include "CompileCommands.fx"


///////////////////////////////////////////////////////////////////////  
//  Because the PS3 does not support run-time compilation, it is necessary to
//  specify which registers the shared global variables should be stored in.  This
//  macro handles this appropriately with PS3 is #defined and is ignored otherwise.

#ifdef PS3
    #define REG(x) : C##x
#else
    #define REG(x)// : register(c##x)
#endif


///////////////////////////////////////////////////////////////////////  
//  Shadow #defines

#ifndef SPEEDTREE_SMOOTH_SHADOWS
    #define SPEEDTREE_SMOOTH_SHADOWS false
#endif
#ifdef SPEEDTREE_SHADOW_MAP_RES
    #define SPEEDTREE_SHADOWS_ENABLED
#endif
#define SPEEDTREE_CLIP_OFFSET 0.0f

// some experimental settings; use as a basis for your own experimentation
//#define SPEEDTREE_WIND_AFFECTS_LIGHTING
//#define SPEEDTREE_BILLBOARDS_RECEIVE_SHADOWS


///////////////////////////////////////////////////////////////////////  
//  Lighting default #defines

#ifndef SPEEDTREE_SPECULAR_LIGHTING
    #define SPEEDTREE_SPECULAR_LIGHTING false
#endif
#ifndef SPEEDTREE_TRANSMISSION_LIGHTING
    #define SPEEDTREE_TRANSMISSION_LIGHTING false
#endif
#ifndef SPEEDTREE_AMBIENT_CONTRAST
    #define SPEEDTREE_AMBIENT_CONTRAST false
#endif
#ifndef SPEEDTREE_DETAIL_TEXTURE
    #define SPEEDTREE_DETAIL_TEXTURE false
#endif
#ifndef SPEEDTREE_DETAIL_NORMAL_MAPPING
    #define SPEEDTREE_DETAIL_NORMAL_MAPPING false
#endif


///////////////////////////////////////////////////////////////////////  
//  Common Global Variables
//
//  These are all global variables that are shared by more than one of
//  the main shader types (branch, frond, leaf, and billboard).  The constant
//  registers are specified after many of the global parameters in order
//  to ensure that the variables will be successfully shared even when the
//  shaders are compiled off-line separately.
//
//  Note: What we call "composite maps" or "composite textures" are also known
//        as "texture atlases"

float4x4    g_mModelViewProj        REG(0);     // composite modelview/projection matrix
float4      g_vTreePosAndScale      REG(4);     // xyz = position, w = scale
float4      g_vTreeRotation         REG(5);     // xyz = rotation values, w = lod value (1 = highest, 0 = lowest)
float4      g_vLodProfile           REG(6);     // x = high 3D LOD distance, y = low 3D LOD distance, z = billboard start distance, w = billboard final distance
float4x4    g_mMaterial             REG(7);     // [0] = ambient  (material_ambient * light_ambient)
                                                // [1] = diffuse  (material_diffuse * light_diffuse)
                                                // [2] = specular (material_specular * light_specular), w = shininess [0-128]
                                                // [3] = emissive (material_emissive * light_emissive)
float4      g_vMaterialExtras       REG(11);    // x = light scalar, y = alpha scalar, z = shininess, w = 1.0 - ambient_contrast
float2      g_vMaterialTransmission REG(12);    // x = shadow darkness, y = view dependence
float3      g_vLightDir             REG(13);    // light direction
float3      g_vSkyColor             REG(14);    // rgb = color, a = horizon offset
float4      g_vFogParams            REG(15);    // x = fog_end, .y = fog_end - fog_start, z = -min sky fog, w = -1.0 / sky fog range
float3      g_vFogColor             REG(16);    // rgb fog color
float3      g_vSunColor             REG(17);    // rgb sun color
float3      g_vSunParams            REG(18);    // x = size, y = spread exponent, z = fog bloom
float3      g_vCameraPosition       REG(19);    // camera/eye location in world space
float3      g_vCameraDirection      REG(20);    // camera/eye direction in world space
float2      g_vCameraAngles         REG(21);    // shared by Billboard.fx and Leaf.fx - stores camera azimuth and pitch for billboarding computations
float       g_fFarClip              REG(22);    // far clipping plane distance (visibility)
float       g_fHorzBillboardFade    REG(23);    // 0 = horz bbs are transparent, 1 = they are opaque
float4      g_vSplatMapTiles        REG(24);    // x = splat0 tile, y = splat1 tile, z = splat2 tile, w = normal map blue scalar
float4      g_vSplitDistances       REG(25);    // x = shadow_map_0_end, y = shadow_map_1_end, etc.
float3      g_vShadowFadeParams     REG(26);    // x = shadow fade %, y = 1/(fade% - end), z = 1/(end - fade%); all to reduce pixel shader instructions

// wind
float3      g_vWindDir              REG(27);    // xyz = dir
float4      g_vWindTimes            REG(28);    // x = primary, y = secondary, z = frond, w = leaves
float4      g_vWindDistances        REG(29);    // x = primary osc, y = secondary osc, z = wind height, w = height exponent
float3      g_vWindLeaves           REG(30);    // x = distance, y = leaves lighting change, z = leaves windward scalar
float3      g_vWindFrondRipple      REG(31);    // x = amount, y = u tile, z = v tile
float3      g_vWindGust             REG(32);    // x = combined wind strength, y = primary distance, z = gust scale
float3      g_vWindGustHints        REG(33);    // x = vertical offset %, y = wind dir adjustment, z = unison

// variable-sized shadow
#ifdef SPEEDTREE_SHADOWS_ENABLED
    float4x4    g_amLightViewProjs[SPEEDTREE_NUM_SHADOW_MAPS] REG(34);
    float       g_afSplitDistances[SPEEDTREE_NUM_SHADOW_MAPS];
#endif


#include "Textures.fx"
#include "Utility.fx"
#include "Shadows.fx"
#include "Lighting.fx"
#include "Wind.fx"
#include "Branch.fx"
#include "Frond.fx"
#include "LeafCard.fx"
#include "LeafMesh.fx"
#include "Billboard.fx"
#include "Terrain.fx"
#include "Grass.fx"
#include "Sky.fx"
#include "Overlays.fx"



